#ifndef _AUTOPTR_H_
#define _AUTOPTR_H_

#include "ge_math.h"

template <class TYPE> class AutoAlloc
{
		TYPE *ptr;

	public:

		AutoAlloc()						{ ptr = TYPE::Alloc(); }
		AutoAlloc(LONG id)		{ ptr = TYPE::Alloc(id); }
		AutoAlloc(LONG p1, LONG p2)		{ ptr = TYPE::Alloc(p1,p2); }
		AutoAlloc(TYPE* initptr) { ptr = initptr; }
		~AutoAlloc()					{ TYPE::Free(ptr); ptr = NULL; }
		operator TYPE* ()			{ return ptr; }
		operator TYPE& ()			{ return *ptr; }
		TYPE *operator -> ()	{ return ptr; }
		TYPE *const *operator & ()	{ return &ptr; }
		TYPE *Release() { TYPE *tmp=ptr; ptr=NULL; return tmp; }
};

template <class TYPE> class AutoNew
{
		TYPE *ptr;

	public:

		AutoNew()							{ ptr = gNew TYPE; }
		~AutoNew()						{ gDelete(ptr); }
		operator TYPE* ()			{ return ptr; }
		operator TYPE& ()			{ return *ptr; }
		TYPE *operator -> ()	{ return ptr; }
		TYPE *const *operator & ()	{ return &ptr; }
		TYPE *Release() { TYPE *tmp=ptr; ptr=NULL; return tmp; }
};

template <class TYPE> class AutoPtr
{
		TYPE *ptr;

	public:

		AutoPtr(TYPE *p)			{ ptr = p; }
		~AutoPtr()						{ gDelete(ptr); }
		operator TYPE* ()			{ return ptr; }
		operator TYPE& ()			{ return *ptr; }
		TYPE *operator -> ()	{ return ptr; }
		TYPE *const *operator & ()	{ return &ptr; }
		TYPE *Release() { TYPE *tmp=ptr; ptr=NULL; return tmp; }
};

#endif
